/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.palette.VWDraggablePaletteItemUI;
import filenet.vw.toolkit.design.palette.VWStepPaletteWrapper;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.datatransfer.VWTransferable;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import filenet.vw.toolkit.utils.uicontrols.VWImageIcon;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.net.URL;
import javax.swing.ImageIcon;

public class VWStepPaletteItemUI
extends VWDraggablePaletteItemUI
implements DragGestureListener,
IVWSortItem {
    private static final ImageIcon ICON_COMPONENT_STEP = VWImageLoader.createImageIcon("componentstep_sp.gif");
    private static final ImageIcon ICON_COMPONENT_STEP_H = VWImageLoader.createImageIcon("componentstep_sp_h.gif");
    private static final ImageIcon ICON_DUMMY_STEP = VWImageLoader.createImageIcon("dummystep_sp.gif");
    private static final ImageIcon ICON_DUMMY_STEP_H = VWImageLoader.createImageIcon("dummystep_sp_h.gif");
    private static final ImageIcon ICON_QUEUE_STEP = VWImageLoader.createImageIcon("queuestep_sp.gif");
    private static final ImageIcon ICON_QUEUE_STEP_H = VWImageLoader.createImageIcon("queuestep_sp_h.gif");
    private static final ImageIcon ICON_SUBMAP_STEP = VWImageLoader.createImageIcon("callstep_sp.gif");
    private static final ImageIcon ICON_SUBMAP_STEP_H = VWImageLoader.createImageIcon("callstep_sp_h.gif");
    private static final ImageIcon ICON_SYSTEM_STEP = VWImageLoader.createImageIcon("systemstep_sp.gif");
    private static final ImageIcon ICON_SYSTEM_STEP_H = VWImageLoader.createImageIcon("systemstep_sp_h.gif");
    private static final ImageIcon ICON_USER_STEP = VWImageLoader.createImageIcon("userstep_sp.gif");
    private static final ImageIcon ICON_USER_STEP_H = VWImageLoader.createImageIcon("userstep_sp_h.gif");
    protected VWMapNode m_vwMapNode = null;
    protected VWStepPaletteWrapper m_stepPaletteWrapper = null;
    protected VWDesignerCoreData m_designerCoreData = null;

    public VWStepPaletteItemUI(VWMapNode vwMapNode, VWDesignerCoreData designerCoreData, VWStepPaletteWrapper stepPaletteWrapper) {
        this.m_vwMapNode = vwMapNode;
        this.m_designerCoreData = designerCoreData;
        this.m_stepPaletteWrapper = stepPaletteWrapper;
        this.setToolTipText(vwMapNode.getName());
        this.setIcon();
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 1, this);
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        try {
            if (this.m_vwMapNode != null) {
                VWTransferable transferableObj;
                StringBuffer xmlStream = new StringBuffer();
                this.m_vwMapNode.toXML(xmlStream);
                if (xmlStream != null && (transferableObj = new VWTransferable(xmlStream.toString())) != null) {
                    dge.startDrag(DragSource.DefaultCopyDrop, transferableObj, this);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getName() {
        if (this.m_vwMapNode != null) {
            return this.m_vwMapNode.getName();
        }
        return null;
    }

    protected VWStepPaletteWrapper getStepPaletteWrapper() {
        return this.m_stepPaletteWrapper;
    }

    protected VWMapNode getMapNode() {
        return this.m_vwMapNode;
    }

    private void setIcon() {
        this.loadCustomIcons();
        if (this.m_normalIcon == null) {
            int nStepType = VWStepUtils.getStepType(this.m_vwMapNode);
            if (VWStepUtils.isComponentStep(nStepType)) {
                this.m_normalIcon = ICON_COMPONENT_STEP;
                this.m_hoverIcon = ICON_COMPONENT_STEP_H;
            } else if (VWStepUtils.isGeneralStep(nStepType)) {
                this.m_normalIcon = ICON_DUMMY_STEP;
                this.m_hoverIcon = ICON_DUMMY_STEP_H;
                if (this.m_vwMapNode != null & this.m_vwMapNode instanceof VWStepDefinition) {
                    VWStepDefinition stepDef = (VWStepDefinition)this.m_vwMapNode;
                    if (stepDef.getParticipants() == null && stepDef.getQueueName() == null) {
                        this.m_normalIcon = ICON_DUMMY_STEP;
                        this.m_hoverIcon = ICON_DUMMY_STEP_H;
                    } else if (stepDef.getParticipants() == null && stepDef.getQueueName() != null && !stepDef.getQueueName().equals("Inbox")) {
                        this.m_normalIcon = ICON_QUEUE_STEP;
                        this.m_hoverIcon = ICON_QUEUE_STEP_H;
                    } else {
                        this.m_normalIcon = ICON_USER_STEP;
                        this.m_hoverIcon = ICON_USER_STEP_H;
                    }
                }
            } else if (VWStepUtils.isSubmapStep(nStepType)) {
                this.m_normalIcon = ICON_SUBMAP_STEP;
                this.m_hoverIcon = ICON_SUBMAP_STEP_H;
            } else if (VWStepUtils.isSystemStep(nStepType)) {
                this.m_normalIcon = ICON_SYSTEM_STEP;
                this.m_hoverIcon = ICON_SYSTEM_STEP_H;
            }
        }
        if (this.m_normalIcon != null) {
            this.setIcon(this.m_normalIcon);
            this.setSize(this.m_normalIcon.getIconWidth(), this.m_normalIcon.getIconHeight());
        }
    }

    private void loadCustomIcons() {
        try {
            VWSessionInfo sessionInfo;
            ClassLoader externalClassLoader;
            Object obj;
            String imageName = null;
            VWAttributeInfo attributeInfo = this.m_vwMapNode.getAttributeInfo();
            if (attributeInfo != null && (obj = attributeInfo.getFieldValue("UI_IconName")) != null && obj instanceof String) {
                imageName = (String)obj;
            }
            if (imageName != null && imageName.length() > 0 && (externalClassLoader = (sessionInfo = this.m_designerCoreData.getSessionInfo()).getExternalClassLoader()) != null) {
                URL imageURL = externalClassLoader.getResource(imageName + "_sp.gif");
                if (imageURL != null) {
                    this.m_normalIcon = new VWImageIcon(imageURL);
                }
                if ((imageURL = externalClassLoader.getResource(imageName + "_sp_h.gif")) != null) {
                    this.m_hoverIcon = new VWImageIcon(imageURL);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

